<?php
/**
 * 404 Error Page Template
 *
 * This template displays when a requested page cannot be found (404 error).
 * It provides a user-friendly error message and search functionality to help
 * visitors find the content-managers they were looking for.
 *
 * @package    WVC_Theme
 * @subpackage Templates
 * @author     10Web
 * @since      1.0.0
 * @version    1.0.0
 * @link       https://github.com/your-repo/wvc-theme
 */

// phpcs:disable Generic.WhiteSpace.DisallowSpaceIndent

get_header(); ?>

<main class="site-main bg-primary-100 min-h-screen py-12">
    <div class="container mx-auto px-4 max-w-7xl">
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <!-- Main Content Area -->
            <div class="lg:col-span-2">
                <section class="error-404 not-found bg-white rounded-lg border border-gray-500 p-8 mb-8">
                    <header class="page-header mb-6">
                        <h1 class="page-title text-4xl font-bold text-black mb-4">
                            <?php esc_html_e( 'Oops! That page can&rsquo;t be found.', 'wvc-theme' ); ?>
                        </h1>
                    </header>

                    <div class="page-content">
                        <p class="text-lg text-black mb-8">
                            <?php esc_html_e( 'It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'wvc-theme' ); ?>
                        </p>

                        <div class="mb-8">
                            <?php get_search_form(); ?>
                        </div>
                    </div>
                </section>

                <!-- Widgets Grid -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Most Used Categories Widget -->
                    <div class="widget bg-white rounded-lg border border-gray-500 p-6">
                        <h2 class="widget-title text-xl font-semibold text-black mb-4">
                            <?php esc_html_e( 'Most Used Categories', 'wvc-theme' ); ?>
                        </h2>
                        <ul class="space-y-2">
                            <?php
                            wp_list_categories(
                                array(
                                    'orderby'    => 'count',
                                    'order'      => 'DESC',
                                    'show_count' => 1,
                                    'title_li'   => '',
                                    'number'     => 10,
                                    'echo'       => 1,
                                    'walker'     => new class extends Walker_Category {
                                        public function start_el( &$output, $category, $depth = 0, $args = array(), $id = 0 ) {
                                            $output .= '<li class="flex justify-between items-center py-2 border-b border-gray-200 last:border-b-0">';
                                            $output .= '<a href="' . esc_url( get_term_link( $category ) ) . '" class="text-primary-500 hover:text-primary-700 transition-colors">' . esc_html( $category->name ) . '</a>';
                                            if ( $args['show_count'] ) {
                                                $output .= '<span class="text-sm text-gray-500 bg-gray-100 px-2 py-1 rounded">' . $category->count . '</span>';
                                            }
                                            $output .= '</li>';
                                        }
                                    }
                                )
                            );
                            ?>
                        </ul>
                    </div>

                    <!-- Recent Posts Widget -->
                    <div class="widget bg-white rounded-lg border border-gray-500 p-6">
                        <h2 class="widget-title text-xl font-semibold text-black mb-4">
                            <?php esc_html_e( 'Recent Posts', 'wvc-theme' ); ?>
                        </h2>
                        <ul class="space-y-2">
                            <?php
                            wp_get_archives(
                                array(
                                    'type'  => 'postbypost',
                                    'limit' => 5,
                                    'echo'  => 1,
                                    'format' => 'custom',
                                    'before' => '<li class="py-2 border-b border-gray-200 last:border-b-0">',
                                    'after'  => '</li>',
                                    'link_before' => '<a href="%link%" class="text-primary-500 hover:text-primary-700 transition-colors">',
                                    'link_after'  => '</a>'
                                )
                            );
                            ?>
                        </ul>
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="lg:col-span-1">
                <div class="bg-white rounded-lg border border-gray-500 p-6">
                    <?php get_sidebar(); ?>
                </div>
            </div>
        </div>
    </div>
</main>

<?php get_footer(); ?>