# WVC WordPress Theme

A modern, responsive WordPress theme built with React components, Radix UI primitives, and CSS custom properties.

## Features

- **Modern Design System**: Built with CSS custom properties for consistent styling
- **React Components**: Interactive components built with Radix UI primitives
- **Responsive Design**: Mobile-first approach with flexible grid system
- **Accessibility**: WCAG 2.1 compliant with proper ARIA labels and keyboard navigation
- **Dark Mode Support**: Automatic dark mode based on user preferences
- **SEO Optimized**: Semantic HTML structure and meta tag support
- **Custom Post Types**: Extended functionality with custom fields
- **Widget Ready**: Multiple widget areas for content customization

## Theme Structure

```
wvc-theme/
├── assets/
│   ├── css/
│   │   ├── variables.css      # CSS custom properties
│   │   └── components.css     # React component styles
│   └── js/
│       └── main.js           # Theme JavaScript
├── components/               # React components
│   ├── Button.jsx           # Button component
│   ├── Card.jsx             # Card component
│   ├── Modal.jsx            # Modal component
│   ├── Dropdown.jsx         # Dropdown component
│   └── index.js             # Component exports
├── functions.php            # Theme functions
├── style.css               # Main stylesheet
├── index.php               # Main template
├── header.php              # Header template
├── footer.php              # Footer template
├── single.php              # Single post template
├── page.php                # Page template
├── archive.php             # Archive template
├── search.php              # Search results template
├── 404.php                 # 404 error template
├── sidebar.php             # Sidebar template
├── searchform.php          # Search form template
├── comments.php            # Comments template
└── README.md               # Documentation
```

## Installation

1. Download or clone this repository
2. Upload the theme folder to your WordPress `/wp-content/themes/` directory
3. Activate the theme in WordPress Admin > Appearance > Themes
4. Customize the theme in WordPress Admin > Appearance > Customize

## CSS Variables

The theme uses a comprehensive design system with CSS custom properties:

### Colors
- Primary: `--color-primary`, `--color-primary-light`, `--color-primary-dark`
- Secondary: `--color-secondary`, `--color-secondary-light`, `--color-secondary-dark`
- Text: `--color-text-primary`, `--color-text-secondary`, `--color-text-tertiary`
- Background: `--color-background`, `--color-surface`
- Status: `--color-success`, `--color-warning`, `--color-error`

### Typography
- Font families: `--font-primary`, `--font-heading`
- Font sizes: `--font-size-xs` through `--font-size-3xl`
- Font weights: `--font-weight-light` through `--font-weight-extrabold`
- Line heights: `--line-height-tight` through `--line-height-loose`

### Spacing
- Spacing scale: `--spacing-xs` through `--spacing-3xl`
- Border radius: `--border-radius-xs` through `--border-radius-2xl`
- Shadows: `--shadow-xs` through `--shadow-2xl`

## React Components

The theme includes several React components built with Radix UI:

### Button Component
```jsx
import { Button } from "./components";

<Button variant="primary" size="medium">
  Click me
</Button>
```

### Card Component
```jsx
import { Card, CardHeader, CardTitle, CardContent } from "./components";

<Card>
  <CardHeader>
    <CardTitle>Card Title</CardTitle>
  </CardHeader>
  <CardContent>
    Card content goes here
  </CardContent>
</Card>
```

### Modal Component
```jsx
import { Modal, ModalTrigger, ModalContent, ModalTitle } from "./components";

<Modal>
  <ModalTrigger>Open Modal</ModalTrigger>
  <ModalContent>
    <ModalTitle>Modal Title</ModalTitle>
    <p>Modal content</p>
  </ModalContent>
</Modal>
```

## Theme Features

### Navigation
- Responsive navigation with mobile menu
- Search functionality
- Accessibility-focused keyboard navigation

### Posts and Pages
- Featured images support
- Custom excerpt length
- Related posts
- Author bio sections
- Post navigation

### Widgets
- Header search
- Sidebar widgets
- Footer widget areas
- Custom widget styling

### Customization
- WordPress Customizer integration
- Custom logo support
- Menu management
- Color customization

## Browser Support

- Chrome 88+
- Firefox 85+
- Safari 14+
- Edge 88+

## Development

### Prerequisites
- WordPress 5.0+
- PHP 7.4+
- Modern browser with ES6 support

### Getting Started
1. Clone the repository
2. Ensure WordPress is running
3. Activate the theme
4. Start customizing!

### CSS Custom Properties
All styling is based on CSS custom properties defined in `assets/css/variables.css`. Modify these values to customize the theme's appearance.

### React Components
Components are built with Radix UI primitives for accessibility. To add new components:

1. Create a new file in the `components/` directory
2. Export the component in `components/index.js`
3. Add corresponding styles to `assets/css/components.css`

## Accessibility

The theme is built with accessibility in mind:

- Semantic HTML structure
- Proper heading hierarchy
- ARIA labels and descriptions
- Keyboard navigation support
- Screen reader compatibility
- High contrast mode support

## Performance

- Minimal JavaScript footprint
- CSS custom properties for efficient styling
- Responsive images
- Lazy loading support
- Optimized asset loading

## License

This theme is licensed under the GPL v2 or later.

## Contributing

1. Fork the repository
2. Create a feature branch
3. Make your changes
4. Test thoroughly
5. Submit a pull request

## Support

For support and questions, please create an issue in the repository.

## Changelog

### Version 1.0.0
- Initial release
- Complete WordPress theme structure
- React components with Radix UI
- CSS custom properties design system
- Responsive design
- Accessibility features
