<?php

/**
 * Footer Template
 *
 * This file contains the site footer structure including footer widgets,
 * copyright information, footer navigation, and closing page wrapper.
 * Used by all theme templates.
 *
 * @package    WVC_Theme
 * @subpackage Templates
 * @author     10Web
 * @since      1.0.0
 * @version    1.0.0
 * @link       https://github.com/your-repo/wvc-theme
 */


 $wvc_editor_meta = false;
if(is_singular()){
    $id = get_the_ID();
    $wvc_editor_meta = \WVC\Core\Core::get_wvc_editor_meta($id);
}

$template = false;

if(is_singular()){
    $is_vibecode_singular = \WVC\Core\Core::is_vibecode_singular();
	$template = \WVC\Core\Core::get_vibecode_singular_template("single", get_post_type());
}
elseif(is_archive()){
    $is_vibecode_archive = \WVC\Core\Core::get_vibecode_archive_template();
	$template = \WVC\Core\Core::get_vibecode_archive_template();
}
else{
    $template = false;
}
# if there is a footer template, then we need to output it instead of the default footer

$has_wvc_footer_template = false;
$footer_content = '';

if (!$wvc_editor_meta && !$template) {
    // if this is a regular page, then we need to check for a footer template

    // Check for WVC footer template
    $footer_template = get_posts(array(
        'post_type' => 'wvc_template',
        'post_status' => 'publish',
        'meta_query' => array(
            array(
                'key' => '_wvc_template_type',
                'value' => 'footer',
                'compare' => '='
            )
        ),
        'posts_per_page' => 1,
        'orderby' => 'ID',
        'order' => 'ASC'
    ));

    if (!empty($footer_template)) {
        $has_wvc_footer_template = true;
        $footer_post = $footer_template[0];
        $footer_content = $footer_post->post_content;
    }
}

if ($wvc_editor_meta || $template || $has_wvc_footer_template):

    // Pass variables to the template using get_template_part with args
    get_template_part('wvc-footer', null, array(
        'footer_content' => $footer_content,
        'has_wvc_footer_template' => $has_wvc_footer_template
    ));

    return;
endif;




?>

</div><!-- #content -->

<footer id="colophon" class="site-footer bg-black text-white">
    <div class="container mx-auto px-4 py-8">
        <?php if (is_active_sidebar("footer-1")) : ?>
            <div class="footer-content mb-8">
                <?php dynamic_sidebar("footer-1"); ?>
            </div>
        <?php endif; ?>

        <div class="footer-bottom border-t border-white/20 pt-6">
            <div class="footer-info flex flex-col md:flex-row justify-between items-center gap-4">
                <p class="text-sm text-white/90">
                    &copy; <?php echo date("Y"); ?>
                    <a href="<?php echo esc_url(home_url("/")); ?>" class="text-white hover:text-primary-300 transition-colors duration-200">
                        <?php bloginfo("name"); ?>
                    </a>.
                    <?php _e("All rights reserved.", "wvc-theme"); ?>
                </p>

                <?php if (has_nav_menu("footer")) : ?>
                    <nav class="footer-navigation">
                        <?php
                        wp_nav_menu(
                            array(
                                "theme_location" => "footer",
                                "menu_id"        => "footer-menu",
                                "container"      => false,
                                "menu_class"     => "footer-menu flex flex-wrap gap-6 text-sm",
                                "depth"          => 1,
                            )
                        );
                        ?>
                    </nav>
                <?php endif; ?>
            </div>

            <div class="footer-credits mt-4 text-center md:text-left">
                <p class="text-xs text-white/70">
                    <?php printf(
                        esc_html__("Powered by %1\$s | Theme: %2\$s", "wvc-theme"),
                        "<a href=\"https://wordpress.org/\" class=\"text-white/90 hover:text-primary-300 transition-colors duration-200\">WordPress</a>",
                        "WVC Theme"
                    ); ?>
                </p>
            </div>
        </div>
    </div>
</footer>
</div><!-- #page -->

<?php wp_footer(); ?>

</body>

</html>