<?php

namespace WVC;

/**
 * WVC Theme Functions
 *
 * This file contains the main theme initialization and entry point.
 * Pure theme functionality has been moved to includes/theme/theme.php
 *
 * @package    WVC_Theme
 * @subpackage Functions
 * @author     10Web
 * @since      1.0.0
 * @version    1.0.17
 * @link       https://github.com/your-repo/wvc-theme
 */

// Prevent direct access
if ( ! defined("ABSPATH")) {
    exit;
}


require_once get_template_directory() . "/includes/index.php";




/**
 * Enqueue shortcode compiler script
 */
function wvc_enqueue_shortcode_compiler() {
    wp_enqueue_script(
        'wvc-shortcode-compiler',
        get_template_directory_uri() . '/short-code.compiler.js',
        array(),
        '1.0.0',
        true // Load in footer
    );
}
add_action('wp_enqueue_scripts', __NAMESPACE__ . '\wvc_enqueue_shortcode_compiler');

/**
 * Localize data for WVC script (runs later to ensure wvc script is loaded)
 */
function wvc_localize_handler_data() {
    if (wp_script_is('wvc', 'enqueued')) {
        
        // Base data
        $data = array(
            'ajaxUrl' => admin_url('admin-ajax.php'),
            'pageId'  => get_the_ID(),
            'nonce'   => wp_create_nonce('wvc_nonce'),
            'action'  => 'wvc_form_submit',
            'homeUrl' => home_url(),
        );
        
        // Add WooCommerce data if available
        if ( class_exists( 'WooCommerce' ) ) {
            
            
            $data['woocommerce'] = array(
                'cartUrl'     => wc_get_cart_url(),
                'checkoutUrl' => wc_get_checkout_url(),
                'currency'    => get_woocommerce_currency_symbol(),
            );
        }
        
        wp_localize_script( 'wvc', 'wvcHandlerData', $data );
    }
}
add_action('wp_enqueue_scripts', __NAMESPACE__ . '\wvc_localize_handler_data', 15);
