<?php

namespace WVC\FormSubmissions;

/**
 * Admin Dashboard - Dashboard Widget
 *
 * Dashboard widget showing form statistics
 *
 * @package    WVC_Theme
 * @subpackage FormSubmissions
 */

// Prevent direct access
if (!defined("ABSPATH")) {
    exit;
}

/**
 * Add dashboard widget for recent form submissions
 */
function wvc_add_dashboard_widget() {
    wp_add_dashboard_widget(
        'wvc_recent_form_submissions',
        'Recent Form Submissions',
        __NAMESPACE__ . '\wvc_dashboard_widget_content'
    );
}

/**
 * Dashboard widget content
 */
function wvc_dashboard_widget_content() {
    $recent_submissions = get_posts(array(
        'post_type' => 'wvc_form_data',
        'post_status' => 'private',
        'posts_per_page' => 5,
        'orderby' => 'date',
        'order' => 'DESC'
    ));

    if (empty($recent_submissions)) {
        echo '<p>No form submissions yet.</p>';
        return;
    }

    echo '<table style="width: 100%;">';
    echo '<thead><tr><th>Form</th><th>Date</th><th>Fields</th><th>Action</th></tr></thead>';
    echo '<tbody>';

    foreach ($recent_submissions as $submission) {
        $form_id = get_post_meta($submission->ID, '_wvc_form_id', true);
        $timestamp = get_post_meta($submission->ID, '_wvc_timestamp', true);
        $form_data_json = get_post_meta($submission->ID, '_wvc_form_data', true);
        $form_data = $form_data_json ? json_decode($form_data_json, true) : array();

        $date = $timestamp ? date('M j, Y H:i', $timestamp / 1000) : get_the_date('M j, Y H:i', $submission->ID);
        $fields_preview = !empty($form_data) ? implode(', ', array_keys($form_data)) : 'No fields';
        if (strlen($fields_preview) > 40) {
            $fields_preview = substr($fields_preview, 0, 37) . '...';
        }

        echo '<tr>';
        echo '<td>' . esc_html($form_id) . '</td>';
        echo '<td>' . esc_html($date) . '</td>';
        echo '<td>' . esc_html($fields_preview) . '</td>';
        echo '<td><a href="' . admin_url('post.php?post=' . $submission->ID . '&action=edit') . '">View</a></td>';
        echo '</tr>';
    }

    echo '</tbody>';
    echo '</table>';

    echo '<p style="text-align: right; margin-top: 10px;">';
    echo '<a href="' . admin_url('edit.php?post_type=wvc_form_data') . '">View All Form Submissions &raquo;</a>';
    echo '</p>';
}
