<?php

namespace WVC\FormSubmissions;

/**
 * Admin Menus - Menu Registration
 *
 * Register admin menus and menu modifications
 *
 * @package    WVC_Theme
 * @subpackage FormSubmissions
 */

// Prevent direct access
if (!defined("ABSPATH")) {
    exit;
}

/**
 * Add custom Form Data menu with Form Overview and Edit Submission
 */
function wvc_add_form_overview_menu() {
    // Add main menu page
    add_menu_page(
        'Form Overview',           // Page title
        'Form Data',              // Menu title
        'manage_options',         // Capability
        'wvc_form_overview',      // Menu slug
        __NAMESPACE__ . '\wvc_form_overview_page', // Callback function
        'dashicons-forms',        // Icon
        30                        // Position
    );

    // Add Form Submissions submenu (hidden from menu but accessible via URL)
    add_submenu_page(
        null, // Hide from menu
        'Form Submissions',
        'Form Submissions',
        'manage_options',
        'wvc_form_submissions',
        __NAMESPACE__ . '\wvc_form_submissions_page'
    );

    // Add Edit Submission submenu (hidden from menu but accessible via URL)
    add_submenu_page(
        null, // Hide from menu
        'Edit Submission',
        'Edit Submission',
        'manage_options',
        'wvc_edit_form_submission',
        __NAMESPACE__ . '\wvc_edit_form_submission_page'
    );
}

/**
 * Remove "Add New" button from form submissions list
 */
function wvc_remove_add_new_button() {
    global $submenu;

    // Remove "Add New" submenu for wvc_form_data post type
    if (isset($submenu['edit.php?post_type=wvc_form_data'])) {
        foreach ($submenu['edit.php?post_type=wvc_form_data'] as $key => $menu_item) {
            if ($menu_item[2] === 'post-new.php?post_type=wvc_form_data') {
                unset($submenu['edit.php?post_type=wvc_form_data'][$key]);
                break;
            }
        }
    }
}

/**
 * Handle redirect to form submissions list
 */
function wvc_redirect_to_submissions() {
    $redirect_url = admin_url('edit.php?post_type=wvc_form_data');
    wp_redirect($redirect_url);
    exit;
}
