<?php

namespace WVC\FormSubmissions;

/**
 * Admin Meta Boxes - Meta boxes for Edit Screens
 *
 * Manages meta boxes for submission edit screens
 *
 * @package    WVC_Theme
 * @subpackage FormSubmissions
 */

// Prevent direct access
if (!defined("ABSPATH")) {
    exit;
}

/**
 * Add meta box for form submission details
 */
function wvc_add_form_submission_meta_box() {
    add_meta_box(
        'wvc_form_submission_details',
        'Form Submission Details',
        __NAMESPACE__ . '\wvc_form_submission_meta_box_callback',
        'wvc_form_data',
        'normal',
        'high'
    );
}

/**
 * Meta box callback to display form submission data
 */
function wvc_form_submission_meta_box_callback($post) {
    // Get all form submission data
    $submission_data = wvc_get_form_submission_data($post->ID);

    echo '<div style="margin: 15px 0;">';

    // Display basic information
    echo '<h3>Submission Information</h3>';
    echo '<table class="form-table">';
    echo '<tr><td><strong>Form ID:</strong></td><td>' . esc_html($submission_data['form_id']) . '</td></tr>';
    echo '<tr><td><strong>Section:</strong></td><td>' . esc_html($submission_data['section_name']) . '</td></tr>';
    echo '<tr><td><strong>Submission Date:</strong></td><td>' . esc_html($submission_data['submission_date']) . '</td></tr>';
    echo '<tr><td><strong>Session ID:</strong></td><td>' . esc_html($submission_data['session_id']) . '</td></tr>';
    echo '<tr><td><strong>Page URL:</strong></td><td><a href="' . esc_url($submission_data['page_url']) . '" target="_blank">' . esc_html($submission_data['page_url']) . '</a></td></tr>';
    echo '<tr><td><strong>User Agent:</strong></td><td>' . esc_html($submission_data['user_agent']) . '</td></tr>';
    echo '<tr><td><strong>Submission Attempt:</strong></td><td>' . esc_html($submission_data['submission_attempt']) . '</td></tr>';
    echo '<tr><td><strong>Form Version:</strong></td><td>' . esc_html($submission_data['form_version']) . '</td></tr>';
    echo '</table>';

    // Display form data
    echo '<h3>Form Data</h3>';
    if (!empty($submission_data['individual_fields'])) {
        echo '<table class="form-table">';
        foreach ($submission_data['individual_fields'] as $field_name => $field_value) {
            echo '<tr>';
            echo '<td style="width: 200px;"><strong>' . esc_html(ucfirst(str_replace('_', ' ', $field_name))) . ':</strong></td>';
            echo '<td>';
            if (strlen($field_value) > 100) {
                echo '<textarea readonly style="width: 100%; height: 80px;">' . esc_textarea($field_value) . '</textarea>';
            } else {
                echo esc_html($field_value);
            }
            echo '</td>';
            echo '</tr>';
        }
        echo '</table>';
    } else {
        echo '<p>No form data available.</p>';
    }

    // Display additional metadata if available
    if (!empty($submission_data['submission_metadata'])) {
        echo '<h3>Additional Information</h3>';
        echo '<table class="form-table">';
        foreach ($submission_data['submission_metadata'] as $key => $value) {
            echo '<tr><td><strong>' . esc_html(ucfirst(str_replace('_', ' ', $key))) . ':</strong></td><td>' . esc_html($value) . '</td></tr>';
        }
        echo '</table>';
    }

    // Display validation errors if any
    if (!empty($submission_data['validation_errors']) && $submission_data['validation_errors'] !== '{}') {
        echo '<h3>Validation Errors</h3>';
        echo '<pre style="background: #f1f1f1; padding: 10px; border-radius: 3px;">' . esc_html($submission_data['validation_errors']) . '</pre>';
    }

    echo '</div>';
}

/**
 * Remove default custom fields meta box for form submissions
 */
function wvc_remove_default_custom_fields() {
    remove_meta_box('postcustom', 'wvc_form_data', 'normal');
}

/**
 * Add custom CSS for form submission edit page
 */
function wvc_admin_form_submission_styles() {
    global $post_type;
    if ($post_type === 'wvc_form_data') {
        echo '<style>
            #postdivrich { display: none; } /* Hide content editor */
            .post-type-wvc_form_data #title { background-color: #f9f9f9; }
            .post-type-wvc_form_data #title:focus { background-color: #fff; }
            .wvc-readonly { background-color: #f9f9f9 !important; }
        </style>';
    }
}
