<?php

namespace WVC\FormSubmissions;

/**
 * WVC Form Schema Post Type Registration
 *
 * Registers custom post type for storing form schemas
 *
 * @package    WVC_Theme
 * @subpackage FormSubmissions
 * @author     10Web
 * @since      1.0.0
 * @version    1.0.0
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Register custom post type for form schemas
 */
function wvc_register_form_schema_post_type()
{
    register_post_type('wvc_form', array(
        'labels'       => array(
            'name'               => __('Forms', 'wvc-theme'),
            'singular_name'      => __('Form', 'wvc-theme'),
            'menu_name'          => __('Forms', 'wvc-theme'),
            'add_new'            => __('Add New', 'wvc-theme'),
            'add_new_item'       => __('Add New Form', 'wvc-theme'),
            'edit_item'          => __('Edit Form', 'wvc-theme'),
            'new_item'           => __('New Form', 'wvc-theme'),
            'view_item'          => __('View Form', 'wvc-theme'),
            'search_items'       => __('Search Forms', 'wvc-theme'),
            'not_found'          => __('No forms found', 'wvc-theme'),
            'not_found_in_trash' => __('No forms found in trash', 'wvc-theme')
        ),
        'public'       => false,
        'show_ui'      => true,
        'show_in_menu' => 'wvc-form-submissions', // Group with form submissions
        'capability_type' => 'post',
        'hierarchical' => false,
        'rewrite'      => false,
        'query_var'    => false,
        'supports'     => array('title'),
        'menu_icon'    => 'dashicons-forms',
        'menu_position' => 29
    ));
}

add_action('init', __NAMESPACE__ . '\\wvc_register_form_schema_post_type');
