<?php
/**
 * WVC Site REST API
 *
 * @since      1.0.0
 * @package    WVC_Editor
 * @subpackage WVC_Editor/REST
 */

// Exit if accessed directly
if ( ! defined('ABSPATH')) {
    exit;
}

require_once get_template_directory() . '/includes/rest/wvc-rest-api.php';
require_once get_template_directory() . '/includes/content-managers/site-manager.php';

/**
 * WVC Site REST API Class
 */
class WVC_Site_REST_API extends WVC_REST_API
{
    /**
     * Constructor
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Register REST API routes
     */
    public function register_routes()
    {
        // Site reset endpoint
        register_rest_route('wvc/v1', '/site/reset', [
            'methods'             => WP_REST_Server::CREATABLE,
            'callback'            => [$this, 'reset_site'],
            'permission_callback' =>
                function (WP_REST_Request $request) {
                    return $this->permissions_check($request, "delete_page");
                }
            ,
            'args'                => [
                'force'   => [
                    'type'        => 'boolean',
                    'default'     => false,
                    'description' => 'Force permanent deletion (true) or move to trash (false)',
                ],
                'exclude' => [
                    'type'        => 'array',
                    'default'     => [],
                    'description' => 'Array of content types to exclude from deletion',
                    'items'       => [
                        'type' => 'string',
                        'enum' => [
                            'posts',
                            'pages',
                            'products',
                            'menus',
                            'categories',
                            'tags',
                            'product_categories',
                            'product_tags',
                            'media',
                            'options'
                        ]
                    ]
                ],
                'delete_plugins' => [
                'type'        => 'array',
                'default'     => [],
                'description' => 'Array of plugins slugs to delete',
                'items'       => [
                    'type' => 'string',
                ]
            ],
            ]
        ]);

    }

    /**
     * Reset site content
     */
    public function reset_site($request)
    {
        $force    = $request->get_param('force');
        $excluded = $request->get_param('exclude') ?: [];
        $delete_plugins= $request->get_param('delete_plugins') ?: [];

        $site_manager = WVC_Site_Manager::get_instance();
        $result       = $site_manager->reset_site($force, $excluded, $delete_plugins);

        $status_code = $result['success'] ? 200 : 500;

        return new WP_REST_Response($result, $status_code);
    }


}

// Initialize the Site REST API
new WVC_Site_REST_API();