<?php
if ( ! defined('ABSPATH')) {
    exit;
}

class WVC_Update_Checker
{

    public function __construct()
    {
        $this->init_hooks();
        $this->setup_auto_update();
    }

    private function init_hooks()
    {
        add_filter('pre_set_transient_update_themes', array($this, 'theme_check_for_update'));
        add_filter('pre_set_site_transient_update_themes', array($this, 'theme_check_for_update'));
    }

    /**
     * Setup auto-update for wvc-theme on first run
     */
    private function setup_auto_update()
    {
        $auto_update_flag = get_option('wvc_theme_auto_update_set');

        // If flag is false or doesn't exist, this is the first time - set auto-update
        if ( ! $auto_update_flag) {
            $auto_update_themes = get_option('auto_update_themes', array());

            // Add wvc-theme to the auto-update list if not already present
            if ( ! in_array('wvc-theme', $auto_update_themes)) {
                $auto_update_themes[] = 'wvc-theme';
                update_option('auto_update_themes', $auto_update_themes);
            }

            // Set the flag to indicate auto-update was automatically configured
            update_option('wvc_theme_auto_update_set', true);
        }
    }

    /**
     * Check for theme updates.
     *
     * @param object $transient The transient object.
     *
     * @return object The updated transient object.
     */
    public function theme_check_for_update($transient)
    {
        if ( ! $transient) {
            # transient might be null, so we need to return it
            return $transient;
        }
        $slug = 'wvc-theme';
        // Compare versions
        $theme         = wp_get_theme($slug);
        $local_version = $theme->get('Version');
        // Query premium/private repo for updates.
        $update = WVC_TenWeb_Api::get_instance()->getPluginUpdateData($slug);

        if ($update && $update['version'] && version_compare($update['version'], $local_version, '>')) {
            // Update is available.
            // $update should be an array containing all of the fields in $item below.
            $transient->response[$slug] = $update;
        } else {
            // No update is available.
            $item = array(
                'theme'        => $slug,
                'new_version'  => $local_version,
                'url'          => '',
                'package'      => '',
                'requires'     => '',
                'requires_php' => '',
            );
            // Adding the "mock" item to the `no_update` property is required
            // for the enable/disable auto-updates links to correctly appear in UI.
            $transient->no_update[$slug] = $item;
        }

        return $transient;

    }
}

// Initialize the update checker
new WVC_Update_Checker();