<?php
/**
 * Single Post Template
 *
 * This template displays individual blog posts. It handles post content-managers,
 * metadata, featured images, author information, comments, and navigation
 * between posts.
 *
 * @package    WVC_Theme
 * @subpackage Templates
 * @author     10Web
 * @since      1.0.0
 * @version    1.0.0
 * @link       https://github.com/your-repo/wvc-theme
 */


$id              = get_the_ID();
$wvc_editor_meta = \WVC\Core\Core::get_wvc_editor_meta($id);

# if this is vibecode page, then we need to output the HTML template

# if there is a single template, then we need to output it instead of the default single

$has_wvc_single_template = false;
$single_content          = '';

// Get current post type
$current_post_type = get_post_type();

// Try to get CPT-specific template using the new function
$single_template = \WVC\Includes\Theme\Theme_Core::is_there_a_vibecode_template("single", $current_post_type);

// Fallback to generic 'single' template for 'post' type if CPT-specific not found
if ( ! $single_template && $current_post_type !== 'post') {
    $single_template = \WVC\Includes\Theme\Theme_Core::is_there_a_vibecode_template("single", "post");
}

if ($single_template) {
    $has_wvc_single_template = true;
    $single_content          = $single_template->post_content;
}


if ($wvc_editor_meta || $has_wvc_single_template):

    // Pass variables to the template using get_template_part with args
    get_template_part('wvc-single', null, array(
        'single_content'          => $single_content,
        'has_wvc_single_template' => $has_wvc_single_template,
        'post_type' => $current_post_type
    ));

    return;
endif;

get_header();
?>

    <main class="site-main bg-white min-h-screen">
        <div class="container mx-auto px-4 py-8 max-w-6xl">
            <?php
            /**
             * Hook: woocommerce_before_single_product.
             *
             * @hooked woocommerce_output_all_notices - 10
             */
            do_action("woocommerce_before_single_product");

            while (have_posts()) :
                the_post();
                global $product;

                if (post_password_required()) {
                    echo get_the_password_form();
                    return;
                }
                ?>
                <div id="product-<?php the_ID(); ?>" <?php wc_product_class("product single-product", $product); ?>>
                    <div class="flex flex-col lg:flex-row gap-8">
                        <!-- Product Images -->
                        <div class="product-images flex-1 lg:max-w-md">
                            <?php
                            /**
                             * Hook: woocommerce_before_single_product_summary.
                             *
                             * @hooked woocommerce_show_product_sale_flash - 10
                             * @hooked woocommerce_show_product_images - 20
                             */
                            do_action("woocommerce_before_single_product_summary");
                            ?>
                        </div>

                        <!-- Product Summary -->
                        <div class="product-summary flex-1">
                            <div class="bg-white rounded-lg border border-gray-500 overflow-hidden">
                                <div class="p-6">
                                    <?php
                                    /**
                                     * Hook: woocommerce_single_product_summary.
                                     *
                                     * @hooked woocommerce_template_single_title - 5
                                     * @hooked woocommerce_template_single_rating - 10
                                     * @hooked woocommerce_template_single_price - 10
                                     * @hooked woocommerce_template_single_excerpt - 20
                                     * @hooked woocommerce_template_single_add_to_cart - 30
                                     * @hooked woocommerce_template_single_meta - 40
                                     * @hooked woocommerce_template_single_sharing - 50
                                     */
                                    do_action("woocommerce_single_product_summary");
                                    ?>

                                    <?php
                                    // Display custom featured text if available
                                    $featured_text = get_post_meta(get_the_ID(), "_wvc_featured_text", true);
                                    if (!empty($featured_text)) :
                                        ?>
                                        <div class="product-featured-text bg-secondary-100 p-4 rounded-lg border-l-4 border-secondary-500 mt-6">
                                            <p class="featured-text text-black italic"><?php echo esc_html($featured_text); ?></p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Product Tabs and Additional Content -->
                    <div class="product-details mt-8">
                        <?php
                        /**
                         * Hook: woocommerce_after_single_product_summary.
                         *
                         * @hooked woocommerce_output_product_data_tabs - 10
                         * @hooked woocommerce_upsell_display - 15
                         * @hooked woocommerce_output_related_products - 20
                         */
                        do_action("woocommerce_after_single_product_summary");
                        ?>
                    </div>

                    <!-- Product Navigation -->
                    <nav class="product-navigation mt-8 bg-white rounded-lg border border-gray-500 overflow-hidden"
                         role="navigation">
                        <h2 class="screen-reader-text"><?php _e("Product navigation", "wvc-theme"); ?></h2>
                        <div class="nav-links flex flex-col md:flex-row">
                            <?php
                            $prev_product = wc_get_product(get_adjacent_post(false, "", true, "product_cat"));
                            $next_product = wc_get_product(get_adjacent_post(false, "", false, "product_cat"));
                            ?>

                            <?php if ($prev_product && $prev_product->is_visible()) : ?>
                                <div class="nav-previous flex-1 p-6 bg-primary-100 hover:bg-primary-200 transition-colors duration-200">
                                    <a href="<?php echo esc_url($prev_product->get_permalink()); ?>" rel="prev" class="block">
                                        <span class="nav-subtitle text-sm text-gray-600 block mb-1"><?php _e("Previous Product",
                                                "wvc-theme"); ?></span>
                                        <span class="nav-title text-lg font-semibold text-black hover:text-primary-600 transition-colors duration-200"><?php echo esc_html($prev_product->get_name()); ?></span>
                                    </a>
                                </div>
                            <?php endif; ?>

                            <?php if ($next_product && $next_product->is_visible()) : ?>
                                <div class="nav-next flex-1 p-6 bg-secondary-100 hover:bg-secondary-200 transition-colors duration-200">
                                    <a href="<?php echo esc_url($next_product->get_permalink()); ?>" rel="next" class="block">
                                        <span class="nav-subtitle text-sm text-gray-600 block mb-1"><?php _e("Next Product",
                                                "wvc-theme"); ?></span>
                                        <span class="nav-title text-lg font-semibold text-black hover:text-secondary-600 transition-colors duration-200"><?php echo esc_html($next_product->get_name()); ?></span>
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </nav>

                    <!-- Comments -->
                    <?php
                    if (comments_open() || get_comments_number()) :
                        comments_template();
                    endif;
                    ?>
                </div>
            <?php
            endwhile;
            /**
             * Hook: woocommerce_after_single_product.
             */
            do_action("woocommerce_after_single_product");
            ?>
        </div>
    </main>

<?php get_footer(); ?>